﻿Imports System.Text
Imports NationalInstruments.NI4882    'Import of GPIB class
Public Class GPIB_NI

    '(0)Class variable
    Private GpibDevice As Device                                                        'GPIB Device
    Public MsgBuf As String = ""                                                        'Received Data

    '(1)Connect
    Public Function OpenInterface(ByVal BoardID As String, ByVal PrimaryAddress As String) As Boolean
        Dim ret As Boolean = False

        Try
            GpibDevice = New Device(Convert.ToInt32(BoardID), Convert.ToByte(PrimaryAddress), 0, TimeoutValue.T1s)  'Create a GPIB object
            ret = True
        Catch Ex As Exception
            MsgBox(Ex.Message)
        End Try

        OpenInterface = ret
    End Function

    '(2)Disconnect
    Public Function CloseInterface() As Boolean
        Dim ret As Boolean = False

        Try
            If Not (GpibDevice Is Nothing) Then
                GpibDevice.Dispose()                                                    'Dispose the GPIB object
            End If
            ret = True
        Catch ex As Exception
            MsgBox(ex.Message)
        End Try

        CloseInterface = ret
    End Function

    '(3)Send commands
    Public Function SendMsg(ByVal strMsg As String) As Boolean
        Dim ret As Boolean = False

        Try
            strMsg += vbCrLf                                                            'Add a terminator, CR+LR, to transmitted command
            GpibDevice.Write(strMsg)                                                    'Write data in the transmit buffer
            ret = True
        Catch Ex As Exception
            MsgBox(Ex.Message)
        End Try

        SendMsg = ret
    End Function

    '(4)Receive
    Public Function ReceiveMsg(ByVal timeout_ms As Long) As Boolean
        Dim ret As Boolean = False
        Dim rcv As String = ""
        Dim buf As New StringBuilder()
        Dim sw As New Stopwatch()

        MsgBuf = ""                                                                     'Clear received data
        sw.Start()                                                                      'Start a stopwatch
        'Continue the loop until LF is received
        Do
            Try
                rcv = ""
                rcv = GpibDevice.ReadString()                                           'Read data from the receive buffer
                rcv = rcv.Replace(vbCr, "")                                             'Delete CR in received data
                If rcv.IndexOf(vbLf) >= 0 Then                                          'End the loop when LF is received
                    rcv = rcv.Substring(0, rcv.IndexOf(vbLf))                           'Extract data without LF and the following from the original received data
                    buf.Append(rcv)                                                     'Save the data
                    MsgBuf = buf.ToString()
                    Exit Do
                Else
                    buf.Append(rcv)                                                     'Save the data
                End If
                'Timeout processing
                If sw.ElapsedMilliseconds > timeout_ms Then                             'Get elapsed time
                    MsgBuf = "Timeout"
                    MsgBox(MsgBuf)
                    ReceiveMsg = ret
                    Exit Function
                End If
            Catch Ex As Exception
                Dim StatusFlag As GpibStatusFlags = GpibDevice.GetCurrentStatus()
                If (StatusFlag And GpibStatusFlags.IOComplete) = 0 Then
                    'Exceptions other than IO Complete
                    MsgBuf = "Error"
                    MsgBox(Ex.Message)
                    ReceiveMsg = ret
                    Exit Function
                Else
                    'Exception IO Complete
                    rcv = rcv.Replace(vbCr, "")                                         'Delete CR in received data
                    If rcv.IndexOf(vbLf) >= 0 Then                                      'End the loop when LF is received
                        rcv = rcv.Substring(0, rcv.IndexOf(vbLf))                       'Extract data without LF and the following from the original received data
                        buf.Append(rcv)                                                 'Save the data
                        MsgBuf = buf.ToString()
                        Exit Do
                    Else
                        buf.Append(rcv)                                                 'Save the data
                    End If
                    'Timeout processing
                    If sw.ElapsedMilliseconds > timeout_ms Then
                        MsgBuf = "Timeout"
                        MsgBox(MsgBuf)
                        ReceiveMsg = ret
                        Exit Function
                    End If
                End If
            End Try
        Loop
        sw.Stop()                                                                       'Stop a stopwatch
        ret = True

        ReceiveMsg = ret
    End Function

    '(5)Transmit and receive commands
    Public Function SendQueryMsg(ByVal strMsg As String, ByVal timeout_ms As Long) As Boolean
        Dim ret As Boolean = False

        ret = SendMsg(strMsg)                                                           'Transmit commands
        If ret Then
            If InStr(strMsg, "?") <> 0 Then
                ret = ReceiveMsg(timeout_ms)                                            'Receive response when command transmission is succeeded
            End If
        End If

        SendQueryMsg = ret
    End Function


End Class
